<?php

/*
Widget Name: Clients widget
Description: A customizable clients widget.
Author: Gfxbucket
Author URI: http://themeforest.net/user/gfxbucket
*/

class Gfxbucket_Clients extends SiteOrigin_Widget {
	function __construct() {
		parent::__construct(
			'gfxbucket-clients',
			__('Gfxbucket Clients', 'gfxbucket-shortcodes'),
			array(
				'description'  => __('Displays images with optional links. Useful for showing company logo images.', 'gfxbucket-shortcodes'),
				'panels_groups' => array('gfxbucket-widgets'),
				'panels_icon' => 'fa fa-users'
			),
			array(),
			array(
				'client' => array(
					'type' => 'repeater',
					'label' => __( 'Client' , 'gfxbucket-shortcodes' ),
					'item_name'  => __( 'Client', 'gfxbucket-shortcodes' ),
					'item_label' => array(
						'selector'     => "[id*='client']",
						'update_event' => 'change',
						'value_method' => 'val'
					),
					'fields' => array(
						'name' => array(
							'type' => 'text',
							'label' => __( 'Title', 'gfxbucket-shortcodes' )
						),
						'image' => array(
							'type' => 'media',
							'label' => __( 'Client Image', 'gfxbucket-shortcodes' ),
							'choose' => __( 'Choose image', 'gfxbucket-shortcodes' ),
							'update' => __( 'Set image', 'gfxbucket-shortcodes' ),
							'library' => 'image',
							'fallback' => true,
						),
						'url' => array(
							'type' => 'text',
							'label' => __( 'Destination URL', 'gfxbucket-shortcodes' )
						),
						'new_window' => array(
							'type' => 'checkbox',
							'label' => __( 'Open in a new window', 'gfxbucket-shortcodes' ),
							'default' => false
						),
					)
				),
			),
			plugin_dir_path(__FILE__)
		);
	}

	function get_template_name($instance) {
		return 'template';
	}

	function get_style_name($instance) {
		return 'style';
	}
}

siteorigin_widget_register('gfxbucket-clients', __FILE__, 'Gfxbucket_Clients');