<?php

/*
Widget Name: member widget
Description: A customizable member widget.
Author: Gfxbucket
Author URI: http://themeforest.net/user/gfxbucket
*/

class Gfxbucket_Member extends SiteOrigin_Widget {
	function __construct() {
		parent::__construct(
			'gfxbucket-member',
			__('Gfxbucket Member', 'gfxbucket-shortcodes'),
			array(
				'description'  => __('Displays a single team member with an optional description field.', 'gfxbucket-shortcodes'),
				'panels_groups' => array('gfxbucket-widgets'),
				'panels_icon' => 'fa fa-user'
			),
			array(),
			array(
				'image' => array(
					'type' => 'media',
					'label' => __( 'Member Image', 'gfxbucket-shortcodes' ),
					'choose' => __( 'Choose image', 'gfxbucket-shortcodes' ),
					'update' => __( 'Set image', 'gfxbucket-shortcodes' ),
					'library' => 'image',
					'fallback' => true
				),
				'text' => array(
					'type' => 'textarea',
					'label' => __( 'Text', 'gfxbucket-shortcodes' ),
					'default' => ''
				),
				'url' => array(
					'type' => 'text',
					'label' => __( 'Destination URL', 'gfxbucket-shortcodes' ),
					'default' => '#'
				),
				'url_text' => array(
					'type' => 'text',
					'label' => __( 'Destination Text', 'gfxbucket-shortcodes' ),
					'default' => __( 'View my works', 'gfxbucket-shortcodes' ),
				),
				'new_window' => array(
					'type' => 'checkbox',
					'label' => __( 'Open in a new window', 'gfxbucket-shortcodes' ),
					'default' => false
				),

			),
			plugin_dir_path(__FILE__)
		);
	}

	function get_template_name($instance) {
		return 'template';
	}

	function get_style_name($instance) {
		return 'style';
	}
}

siteorigin_widget_register('gfxbucket-member', __FILE__, 'Gfxbucket_member');