<?php

/*
Widget Name: Pricing Table widget
Description: A customizable pricing table widget.
Author: Gfxbucket
Author URI: http://themeforest.net/user/gfxbucket
*/

class Gfxbucket_Pricing_Table extends SiteOrigin_Widget {
	function __construct() {
		parent::__construct(
			'gfxbucket-pricing-table',
			__('Gfxbucket Pricing Table', 'gfxbucket-shortcodes'),
			array(
				'description'  => __('Displays a pricing table element.', 'gfxbucket-shortcodes'),
				'panels_groups' => array('gfxbucket-widgets'),
				'panels_icon' => 'fa fa-money'
			),
			array(),
			array(
				'title' => array(
					'type'  => 'text',
					'label' => __( 'Title', 'gfxbucket-shortcodes' )
				),
				'price' => array(
					'type'  => 'text',
					'label' => __( 'Price', 'gfxbucket-shortcodes' )
				),
				'currency' => array(
					'type'    => 'text',
					'label'   => __( 'Currency', 'gfxbucket-shortcodes' ),
					'default' => '$'
				),
				'list' => array(
					'type' => 'repeater',
					'label' => __( 'List' , 'gfxbucket-shortcodes' ),
					'item_name'  => __( 'List', 'gfxbucket-shortcodes' ),
					'item_label' => array(
						'selector'     => "[id*='list']",
						'update_event' => 'change',
						'value_method' => 'val'
					),
					'fields' => array(
						'text' => array(
							'type' => 'text',
							'label' => __( 'Text', 'gfxbucket-shortcodes' )
						),
					)
				),
				'link' => array(
					'type'  => 'text',
					'label' => __( 'Link', 'gfxbucket-shortcodes' )
				),
				'link_text' => array(
					'type'  => 'text',
					'label' => __( 'Link Text', 'gfxbucket-shortcodes' )
				),
			),
			plugin_dir_path(__FILE__)
		);
	}

	function get_template_name($instance) {
		return 'template';
	}

	function get_style_name($instance) {
		return 'style';
	}
}

siteorigin_widget_register('gfxbucket-pricing-table', __FILE__, 'Gfxbucket_Pricing_Table');