<?php

/*
Widget Name: Progress bar widget (2 columns)
Description: A customizable progress bar widget.
Author: Gfxbucket
Author URI: http://themeforest.net/user/gfxbucket
*/

class Gfxbucket_Progress_Bar_Two_Column extends SiteOrigin_Widget {
	function __construct() {
		parent::__construct(
			'gfxbucket-progress-bar-two-column',
			__('Gfxbucket Progress Bar (2 columns)', 'gfxbucket-shortcodes'),
			array(
				'description'  => __('Displays normal progress bars in 2 columns.', 'gfxbucket-shortcodes'),
				'panels_groups' => array('gfxbucket-widgets'),
				'panels_icon' => 'fa fa-tasks'
			),
			array(),
			array(
				'left' => array(
					'type' => 'repeater',
					'label' => __( 'Left Column' , 'gfxbucket-shortcodes' ),
					'item_name'  => __( 'Progress Bar', 'gfxbucket-shortcodes' ),
					'item_label' => array(
						'selector'     => "[id*='progress_bar']",
						'update_event' => 'change',
						'value_method' => 'val'
					),
					'fields' => array(
						'title' => array(
							'type' => 'text',
							'label' => __( 'Title', 'gfxbucket-shortcodes' ),
							'default' => ''
						),
						'subtitle' => array(
							'type' => 'text',
							'label' => __( 'Subtitle', 'gfxbucket-shortcodes' ),
							'default' => ''
						),
						'value' => array(
							'type' => 'number',
							'label' => __( 'Value', 'gfxbucket-shortcodes' ),
							'default' => '30'
						),
						'max' => array(
							'type' => 'number',
							'label' => __( 'Max Value', 'gfxbucket-shortcodes' ),
							'default' => '100'
						),
					)
				),
				'right' => array(
					'type' => 'repeater',
					'label' => __( 'Right Column' , 'gfxbucket-shortcodes' ),
					'item_name'  => __( 'Progress Bar', 'gfxbucket-shortcodes' ),
					'item_label' => array(
						'selector'     => "[id*='progress_bar']",
						'update_event' => 'change',
						'value_method' => 'val'
					),
					'fields' => array(
						'title' => array(
							'type' => 'text',
							'label' => __( 'Title', 'gfxbucket-shortcodes' ),
							'default' => ''
						),
						'subtitle' => array(
							'type' => 'text',
							'label' => __( 'Subtitle', 'gfxbucket-shortcodes' ),
							'default' => ''
						),
						'value' => array(
							'type' => 'number',
							'label' => __( 'Value', 'gfxbucket-shortcodes' ),
							'default' => '30'
						),
						'max' => array(
							'type' => 'number',
							'label' => __( 'Max Value', 'gfxbucket-shortcodes' ),
							'default' => '100'
						),
					)
				)
			),
			plugin_dir_path(__FILE__)
		);
	}

	function get_template_name($instance) {
		return 'template';
	}

	function get_style_name($instance) {
		return 'style';
	}
}

siteorigin_widget_register('gfxbucket-progress-bar-two-column', __FILE__, 'Gfxbucket_Progress_Bar_Two_Column');