<?php

/*
Widget Name: Team widget
Description: A customizable team widget.
Author: Gfxbucket
Author URI: http://themeforest.net/user/gfxbucket
*/

class Gfxbucket_Team extends SiteOrigin_Widget {
	function __construct() {
		parent::__construct(
			'gfxbucket-team',
			__('Gfxbucket Team', 'gfxbucket-shortcodes'),
			array(
				'description'  => __('Displays multiple team members. Each member has an image, name, title and social accounts.', 'gfxbucket-shortcodes'),
				'panels_groups' => array('gfxbucket-widgets'),
				'panels_icon' => 'fa fa-users'
			),
			array(),
			array(
				'team_member' => array(
					'type' => 'repeater',
					'label' => __( 'Team Members' , 'gfxbucket-shortcodes' ),
					'item_name'  => __( 'Team Member', 'gfxbucket-shortcodes' ),
					'item_label' => array(
						'selector'     => "[id*='team_member']",
						'update_event' => 'change',
						'value_method' => 'val'
					),
					'fields' => array(
						'name' => array(
							'type' => 'text',
							'label' => __( 'Name', 'gfxbucket-shortcodes' )
						),
						'title' => array(
							'type' => 'text',
							'label' => __( 'Title', 'gfxbucket-shortcodes' )
						),
						'image' => array(
							'type' => 'media',
							'label' => __( 'Member Image', 'gfxbucket-shortcodes' ),
							'choose' => __( 'Choose image', 'gfxbucket-shortcodes' ),
							'update' => __( 'Set image', 'gfxbucket-shortcodes' ),
							'library' => 'image',
							'fallback' => true,
						),
						'social' => array(
							'type' => 'repeater',
							'label' => __( 'Social Media' , 'gfxbucket-shortcodes' ),
							'item_name'  => __( 'Social Media', 'gfxbucket-shortcodes' ),
							'item_label' => array(
								'selector'     => "[id*='social']",
								'update_event' => 'change',
								'value_method' => 'val'
							),
							'fields' => array(
								'icon' => array(
									'type' => 'icon',
									'label' => __('Select an icon', 'gfxbucket-shortcodes'),
								),
								'url' => array(
									'type' => 'text',
									'label' => __( 'Destination URL', 'gfxbucket-shortcodes' ),
									'default' => '#'
								),
							)
						),
					)
				),
			),
			plugin_dir_path(__FILE__)
		);
	}

	function get_template_name($instance) {
		return 'template';
	}

	function get_style_name($instance) {
		return 'style';
	}
}

siteorigin_widget_register('gfxbucket-team', __FILE__, 'Gfxbucket_Team');