<?php

/*
Widget Name: Twitter widget
Description: A customizable twitter widget.
Author: Gfxbucket
Author URI: http://themeforest.net/user/gfxbucket
*/

class Gfxbucket_Twitter extends SiteOrigin_Widget {
	function __construct() {
		parent::__construct(
			'gfxbucket-twitter',
			__('Gfxbucket Twitter', 'gfxbucket-shortcodes'),
			array(
				'description'  => __('Displays account details of a Twitter account with cover image in the background.', 'gfxbucket-shortcodes'),
				'panels_groups' => array('gfxbucket-widgets'),
				'panels_icon' => 'fa fa-twitter'
			),
			array(),
			array(
				'user_id' => array(
					'type' => 'text',
					'label' => __( 'Twitter Username', 'gfxbucket-shortcodes' ),
					'default' => 'envato'
				),
			),
			plugin_dir_path(__FILE__)
		);
	}

	function get_template_name($instance) {
		return 'template';
	}

	function get_style_name($instance) {
		return 'style';
	}
}

siteorigin_widget_register('gfxbucket-twitter', __FILE__, 'Gfxbucket_Twitter');