<?php

/*
Widget Name: Video widget
Description: A customizable video widget.
Author: Gfxbucket
Author URI: http://themeforest.net/user/gfxbucket
*/

class Gfxbucket_Video extends SiteOrigin_Widget {
	function __construct() {
		parent::__construct(
			'gfxbucket-video',
			__('Gfxbucket Video', 'gfxbucket-shortcodes'),
			array(
				'description'  => __('Embed YouTube or Vimeo videos.', 'gfxbucket-shortcodes'),
				'panels_groups' => array('gfxbucket-widgets'),
				'panels_icon' => 'fa fa-video-camera'
			),
			array(),
			array(
				'type' => array(
					'type' => 'select',
					'label' => __( 'Video Type', 'gfxbucket-shortcodes' ),
					'default' => 'youtube',
					'options' => array(
						'youtube' => __( 'YouTube', 'gfxbucket-shortcodes' ),
						'vimeo' => __( 'Vimeo', 'gfxbucket-shortcodes' ),
					)
				),
				'id' => array(
					'type' => 'text',
					'label' => __( 'Video ID', 'gfxbucket-shortcodes' ),
					'default' => 'nrJtHemSPW4'
				),
				'autoplay' => array(
					'type' => 'checkbox',
					'label' => __( 'Play the video automatically on load. Note that this won’t work on some devices.', 'gfxbucket-shortcodes' ),
					'default' => false
				),
				'loop' => array(
					'type' => 'checkbox',
					'label' => __( 'Play the video again when it reaches the end.', 'gfxbucket-shortcodes' ),
					'default' => false
				),
			),
			plugin_dir_path(__FILE__)
		);
	}

	function get_template_name($instance) {
		return 'video-template';
	}

	function get_style_name($instance) {
		return 'video-style';
	}
}

siteorigin_widget_register('gfxbucket-video', __FILE__, 'Gfxbucket_Video');