<?php
	$categories = get_the_terms( get_the_ID(), 'portfolio_category' );
	$category_list = '';

	if($categories) {
		foreach ($categories as $category) {
			if( $category_list != '' ) {
				$category_list .= ', ';
			}
			$category_list .= $category->name;
		}
	}

	global $more, $image_size;
	$more = 0;

	/* Add no avatar class */

	$post_class = 'blog-posts';

	if( !get_option('show_avatars') ) {
		$post_class .= ' no-avatar';
	}
?>

<article id="Kapost-<?php the_ID(); ?>" <?php post_class($post_class); ?>>
	<header>		
		<?php if ( has_post_thumbnail() ): ?>
			<a class="blog-post-image" href="<?php echo get_the_permalink(); ?>">
				<?php the_post_thumbnail('blog'); ?>
			</a>
			<div class="blog-post-author">
				<?php if( get_option('show_avatars') ): ?>
					<div class="blog-post-author-image">
						<?php echo get_avatar( get_the_author_meta( 'ID' ) ); ?>
					</div>
				<?php endif; ?>
				<div class="blog-post-author-details">
					<?php _e( 'By', 'dropout' ); ?> <span class="author-name"><?php the_author(); ?></span> 
					<?php _e( 'on', 'dropout' ); ?> <time datetime="2014-09-10 17:00"><?php echo get_the_date('M jS, Y'); ?></time> 
					<?php _e( 'in', 'dropout' ); ?> <span class="categories"><?php echo esc_html( $category_list ); ?></span>
				</div>
			</div>
		<?php endif; ?>
		<a href="<?php echo get_the_permalink(); ?>"><h2 class="blog-post-title"><?php the_title(); ?></h2></a>
	</header>
	<div class="blog-post-content">
		<?php if(get_option("rss_use_excerpt") == "0"): ?>
			<?php the_content(); ?>
		<?php else: ?>
			<?php echo str_replace('&nbsp;', '', get_the_excerpt()); ?>
		<?php endif; ?>
	</div>
</article>