<!DOCTYPE html>
<html <?php language_attributes(); ?>>

<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1.0, minimum-scale=1.0, maximum-scale=1.0, user-scalable=0"/>

    <link rel="alternate" hreflang="en" href="https://contractworkplaces.com/en/" />
    <link rel="alternate" hreflang="es" href="https://contractworkplaces.com/web/" />

	<link rel="profile" href="https://gmpg.org/xfn/11">
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">

	<?php Gfxbucket::favicon(); ?>
	<?php Gfxbucket::styling(); ?>
	<?php Gfxbucket::mobile_icon(); ?>

	<!-- Google Tag Manager -->
	<script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
	new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
	j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
	'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
	})(window,document,'script','dataLayer','GTM-PKS844L');</script>
	<!-- End Google Tag Manager -->

	<?php 
	    wp_head();
	    $currentDate = date("Ymd-Hi");
	?>
	
	<link rel="stylesheet" href="<?php echo get_theme_file_uri(); ?>/general.min.css?v=<?php echo $currentDate;?>">
	<link rel="stylesheet" href="<?php echo get_theme_file_uri(); ?>/custom.min.css?v=<?php echo $currentDate;?>">
	
	<!-- Meta Pixel Code -->
    <script>
    !function(f,b,e,v,n,t,s)
    {if(f.fbq)return;n=f.fbq=function(){n.callMethod?
    n.callMethod.apply(n,arguments):n.queue.push(arguments)};
    if(!f._fbq)f._fbq=n;n.push=n;n.loaded=!0;n.version='2.0';
    n.queue=[];t=b.createElement(e);t.async=!0;
    t.src=v;s=b.getElementsByTagName(e)[0];
    s.parentNode.insertBefore(t,s)}(window, document,'script',
    'https://connect.facebook.net/en_US/fbevents.js');
    fbq('init', '388680499915366');
    fbq('track', 'PageView');
    </script>
    <noscript><img height="1" width="1" style="display:none"
    src="https://www.facebook.com/tr?id=388680499915366&ev=PageView&noscript=1"
    /></noscript>
    <!-- End Meta Pixel Code -->
    
    <!-- JSON-LD -->
    <?php if (is_single()) : ?>
    <script type="application/ld+json">
    {
      "@context": "https://schema.org",
      "@type": "Article",
      "headline": "<?php echo get_the_title(); ?>",
      "author": {
        "@type": "Person",
        "name": "<?php echo get_the_author(); ?>"
      },
      "datePublished": "<?php echo get_the_date('c'); ?>",
      "dateModified": "<?php echo get_the_modified_date('c'); ?>",
      "image": "<?php echo get_the_post_thumbnail_url(null, 'full'); ?>",
      "publisher": {
        "@type": "Organization",
        "name": "Contract Workplaces",
        "logo": {
          "@type": "ImageObject",
          "url": "https://contractworkplaces.com/path/to/logo.png"
        }
      },
      "description": "<?php echo get_the_excerpt(); ?>"
    }
    </script>
    <?php endif; ?>
    
</head>

<body <?php body_class(Gfxbucket::body_class()); ?>>

	<!-- Google Tag Manager (noscript) -->
	<noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-PKS844L"
	height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
	<!-- End Google Tag Manager (noscript) -->

	<div class="site">

		<!-- SVGs -->
		<?php include('includes/svg-defs.html'); ?>
		<!-- /SVGs -->

		<?php
			/* Preloader, Header, Breadcrumbs and Page Cover */
			Gfxbucket::preloader();
			Gfxbucket::header();
			Gfxbucket::breadcrumbs();
			Gfxbucket::page_cover();
