<?php
/**
 * Redux Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * any later version.
 *
 * Redux Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Redux Framework. If not, see <http://www.gnu.org/licenses/>.
 *
 * @package     ReduxFramework
 * @author      Dovy Paukstys
 * @version     3.1.5
 */

// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

// Don't duplicate me!
if( !class_exists( 'ReduxFramework_repeater' ) ) {

    /**
     * Main ReduxFramework_repeater class
     *
     * @since       1.0.0
     */
    class ReduxFramework_repeater extends ReduxFramework {
    
        /**
         * Field Constructor.
         *
         * Required - must call the parent constructor, then assign field and value to vars, and obviously call the render field function
         *
         * @since       1.0.0
         * @access      public
         * @return      void
         */
        function __construct( $field = array(), $value ='', $parent ) {
        
            
            $this->parent = $parent;
            $this->field = $field;
            $this->value = $value;

            if ( empty( $this->extension_dir ) ) {
                $this->extension_dir = trailingslashit( str_replace( '\\', '/', dirname( __FILE__ ) ) );
                $this->extension_url = site_url( str_replace( trailingslashit( str_replace( '\\', '/', ABSPATH ) ), '', $this->extension_dir ) );
            }    

            // Set default args for this field to avoid bad indexes. Change this to anything you use.
            $defaults = array(
                'options'           => array(),
                'stylesheet'        => '',
                'output'            => true,
                'enqueue'           => true,
                'enqueue_frontend'  => true
            );
            $this->field = wp_parse_args( $this->field, $defaults );            
        
        }

        /**
         * Field Render Function.
         *
         * Takes the vars and outputs the HTML for the field in the settings
         *
         * @since       1.0.0
         * @access      public
         * @return      void
         */
        public function render() {
            $brands = array(
                'Adn'                 => 'fa-adn',
                'American Express'    => 'fa-cc-amex',
                'Android'             => 'fa-android',
                'AngelList'           => 'fa-angellist',
                'Apple'               => 'fa-apple',
                'Behance'             => 'fa-behance',
                'Behance (square)'    => 'fa-behance-square',
                'Bitbucket'           => 'fa-bitbucket',
                'Bitbucket (square)'  => 'fa-bitbucket-square',
                'Bitcoin'             => 'fa-btc',
                'BuySellAds'          => 'fa-buysellads',
                'CodePen'             => 'fa-codepen',
                'Connect Develop'     => 'fa-connectdevelop',
                'CSS3'                => 'fa-css3',
                'Dashcube'            => 'fa-dashcube',
                'Delicious'           => 'fa-delicious',
                'DeviantArt'          => 'fa-deviantart',
                'Digg'                => 'fa-digg',
                'Discover'            => 'fa-cc-discover',
                'Dribbble'            => 'fa-dribbble',
                'Dropbox'             => 'fa-dropbox',
                'Drupal'              => 'fa-drupal',
                'Empire'              => 'fa-empire',
                'Facebook'            => 'fa-facebook',
                'Facebook (official)' => 'fa-facebook-official',
                'Facebook (square)'   => 'fa-facebook-square',
                'Flickr'              => 'fa-flickr',
                'Forumbee'            => 'fa-forumbee',
                'Foursquare'          => 'fa-foursquare',
                'Git'                 => 'fa-git',
                'Git (square)'        => 'fa-git-square',
                'GitHub'              => 'fa-github',
                'GitHub (alt)'        => 'fa-github-alt',
                'GitHub (square)'     => 'fa-github-square',
                'Google'              => 'fa-google',
                'Google+'             => 'fa-google-plus',
                'Google+ (square)'    => 'fa-google-plus-square',
                'Google Wallet'       => 'fa-google-wallet',
                'Gratipay'            => 'fa-gratipay',
                'Hacker News'         => 'fa-hacker-news',
                'Joomla'              => 'fa-joomla',
                'JSFiddle'            => 'fa-jsfiddle',
                'Last.fm'             => 'fa-lastfm',
                'Last.fm (square)'    => 'fa-lastfm-square',
                'Leanpub'             => 'fa-leanpub',
                'LinkedIn'            => 'fa-linkedin',
                'LinkedIn (square)'   => 'fa-linkedin-square',
                'Linux'               => 'fa-linux',
                'Mastercard'          => 'fa-cc-mastercard',
                'MaxCDN'              => 'fa-maxcdn',
                'meanpath'            => 'fa-meanpath',
                'Medium'              => 'fa-medium',
                'OpenID'              => 'fa-openid',
                'PageLines'           => 'fa-pagelines',
                'PayPal'              => 'fa-paypal',
                'PayPal (alt)'        => 'fa-cc-paypal',
                'Pied Piper'          => 'fa-pied-piper',
                'Pied Piper (alt)'    => 'fa-pied-piper-alt',
                'Pinterest'           => 'fa-pinterest',
                'Pinterest (alt)'     => 'fa-pinterest-p',
                'Pinterest (square)'  => 'fa-pinterest-square',
                'QQ'                  => 'fa-qq',
                'Rebel'               => 'fa-rebel',
                'Reddit'              => 'fa-reddit',
                'Reddit (square)'     => 'fa-reddit-square',
                'Renren'              => 'fa-renren',
                'Sellsy'              => 'fa-sellsy',
                'Share'               => 'fa-share-alt',
                'Share (square)'      => 'fa-share-alt-square',
                'Shirts In Bulk'      => 'fa-shirtsinbulk',
                'SimplyBuilt'         => 'fa-simplybuilt',
                'Skyatlas'            => 'fa-skyatlas',
                'Skype'               => 'fa-skype',
                'Slack'               => 'fa-slack',
                'SlideShare'          => 'fa-slideshare',
                'SoundCloud'          => 'fa-soundcloud',
                'Spotify'             => 'fa-spotify',
                'Stack Exchange'      => 'fa-stack-exchange',
                'Stack Overflow'      => 'fa-stack-overflow',
                'Steam'               => 'fa-steam',
                'Steam (square)'      => 'fa-steam-square',
                'Stripe'              => 'fa-cc-stripe',
                'StumbleUpon'         => 'fa-stumbleupon',
                'StumbleUpon (circle)'=> 'fa-stumbleupon-circle',
                'Tencent Weibo'       => 'fa-tencent-weibo',
                'Trello'              => 'fa-trello',
                'Tumblr'              => 'fa-tumblr',
                'Tumblr (square)'     => 'fa-tumblr-square',
                'Twitch'              => 'fa-twitch',
                'Twitter'             => 'fa-twitter',
                'Twitter (square)'    => 'fa-twitter-square',
                'Viacoin'             => 'fa-viacoin',
                'Vimeo'               => 'fa-vimeo-square',
                'Vine'                => 'fa-vine',
                'Visa'                => 'fa-cc-visa',
                'VKontakte'           => 'fa-vk',
                'WeChat'              => 'fa-weixin',
                'Weibo'               => 'fa-weibo',
                'WhatsApp'            => 'fa-whatsapp',
                'Windows'             => 'fa-windows',
                'WordPress'           => 'fa-wordpress',
                'XING'                => 'fa-xing',
                'XING (square)'       => 'fa-xing-square',
                'Yahoo'               => 'fa-yahoo',
                'Yelp'                => 'fa-yelp',
                'YouTube'             => 'fa-youtube',
                'YouTube (play)'      => 'fa-youtube-play',
                'YouTube (square)'    => 'fa-youtube-square',
            );

            ?>
            <input type="hidden" style="width: 100%" name="<?php echo $this->field['name']; ?>" id="<?php echo $this->field['id']; ?>" value="<?php echo $this->value; ?>" data-repeater="icons">

            <?php
                $icons = explode('|', $this->value);
            ?>
            
            <fieldset class="redux-field-container hidden" data-repeater="template">
                <select style="width: 25em; margin-bottom: .7em;">
                    <option value="0"></option>
                    <?php
                        foreach ($brands as $brand_name => $brand_icon) {
                            echo '<option value="' . $brand_icon . '">' . $brand_name . '</option>';
                        }
                    ?>
                </select>
                <input type="text" class="regular-text">
                <button class="button removeCSS redux-remove-background" data-repeater="remove">Remove</button>
            </fieldset>

            <div data-repeater="wrapper">
                <?php if( $this->value != '' ): ?>
                    <?php foreach( $icons as $icon ):
                        $icon = explode(';', $icon);
                        $icon_val = $icon[0];
                        $icon_url = $icon[1]; ?>

                        <fieldset class="redux-field-container">
                            <select style="width: 25em; margin-bottom: .7em;">
                                <option value="0"></option>
                                <?php
                                    foreach ($brands as $brand_name => $brand_icon) {
                                        $selected = '';

                                        if( $icon_val == $brand_icon ) {
                                            $selected = 'selected';
                                        }

                                        echo '<option value="' . $brand_icon . '"' . $selected . '>' . $brand_name . '</option>';
                                    }
                                ?>
                            </select>
                            <input type="text" class="regular-text" value="<?php echo $icon_url; ?>">
                            <button class="button removeCSS redux-remove-background" data-repeater="remove">Remove</button>
                        </fieldset>
                    <?php endforeach; ?>
                <?php endif;?>
            </div>

            <button class="button" data-repeater="add">Add a new icon</button>
            <?php
        }
    
        /**
         * Enqueue Function.
         */
        public function enqueue() {
            $extension = ReduxFramework_extension_demo_import::getInstance();
        
            wp_enqueue_script(
                'redux-field-repeater', 
                $this->extension_url . 'field_repeater.js', 
                array( 'jquery' ),
                time(),
                true
            );
        }
        
        /**
         * Output Function.
         */        
        public function output() {
            if ( $this->field['enqueue_frontend'] ) { }
        }        
        
    }
}
