<?php

class Gfxbucket_Contact_Info extends WP_Widget {

	/**
	 * Sets up the widgets name etc
	 */
	function __construct() {
		parent::__construct(
			'gfxbucket_contact_info', // Base ID
			__( 'Gfxbucket Contact Information', 'dropout' ), // Name
			array( 'description' => __( 'Phone number, email and address', 'dropout' ), ) // Args
		);
	}

	/**
	 * Outputs the content of the widget
	 *
	 * @param array $args
	 * @param array $instance
	 */
	public function widget( $args, $instance ) {
		$wp_kses_attr_widget = array(
			'div' => array(
				'id' => array(),
				'class' => array(),
			),
		);

		$wp_kses_attr_title = array(
			'h4' => array(
				'class' => array(),
			),
		);

		echo wp_kses( $args['before_widget'], $wp_kses_attr_widget);

		$title = $instance['title'];
		$phone = $instance['phone'];
		$email = $instance['email'];
		$address = $instance['address'];
		$address_url = '';
		if( isset($instance['address_url']) ) {
			$address_url = $instance['address_url'];
		}
		
		if( $address_url == '' ) {
			$address_url = 'https://www.google.com/maps/place/' . str_replace(' ', '+', $address);
		}

		if ( ! empty( $title ) ) {
			echo wp_kses( $args['before_title'] . apply_filters( 'widget_title', $title ). $args['after_title'], $wp_kses_attr_title );
		}

		?>
			<ul class="contact-info">
				<?php if ( ! empty( $phone ) ): ?>
				<li>
					<svg class="phone">
						<use xlink:href="#shape-phone"></use>
					</svg>
					<span><?php echo esc_html( $phone ); ?></span>
				</li>
				<?php endif; ?>

				<?php if ( ! empty( $email ) ): ?>
				<li>
					<svg class="mail">
						<use xlink:href="#shape-mail"></use>
					</svg>
					<a target="_blank" href="<?php echo esc_url( 'mailto:' . $email ); ?>"><?php echo esc_html( $email ); ?></a>			
				</li>
				<?php endif; ?>

				<?php if ( ! empty( $address ) ): ?>
				<li>
					<svg class="map-pin">
						<use xlink:href="#shape-map-pin"></use>
					</svg>
					<a target="_blank" href="<?php echo esc_url( $address_url ); ?>"><?php echo esc_attr( $address ); ?></a>
				</li>
				<?php endif; ?>
			</ul>
		<?php

		echo wp_kses( $args['after_widget'], $wp_kses_attr_widget);
	}

	/**
	 * Outputs the options form on admin
	 *
	 * @param array $instance The widget options
	 */
	public function form( $instance ) {
		$title = ( ! empty( $instance['title'] ) ) ? $instance['title'] : '';
		$phone = ( ! empty( $instance['phone'] ) ) ? $instance['phone'] : '';
		$email = ( ! empty( $instance['email'] ) ) ? $instance['email'] : '';
		$address = ( ! empty( $instance['address'] ) ) ? $instance['address'] : '';
		$address_url = ( ! empty( $instance['address_url'] ) ) ? $instance['address_url'] : '';
		?>
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php _e( 'Title', 'dropout' ); ?>:</label> 
			<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>">
		</p>

		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'phone' ) ); ?>"><?php _e( 'Phone number', 'dropout' ); ?>:</label> 
			<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'phone' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'phone' ) ); ?>" type="text" value="<?php echo esc_attr( $phone ); ?>">
		</p>

		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'email' ) ); ?>"><?php _e( 'Email', 'dropout' ); ?>:</label> 
			<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'email' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'email' ) ); ?>" type="text" value="<?php echo esc_attr( $email ); ?>">
		</p>

		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'address' ) ); ?>"><?php _e( 'Address', 'dropout' ); ?>:</label> 
			<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'address' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'address' ) ); ?>" type="text" value="<?php echo esc_attr( $address ); ?>">
		</p>

		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'address_url' ) ); ?>"><?php _e( 'Address URL', 'dropout' ); ?>:</label> 
			<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'address_url' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'address_url' ) ); ?>" type="text" value="<?php echo esc_attr( $address_url ); ?>">
			<p><?php _e( 'Overwrite the auto generated Google Maps URL', 'dropout' ); ?></p>
		</p>

		<?php 
	}

	/**
	 * Processing widget options on save
	 *
	 * @param array $new_instance The new options
	 * @param array $old_instance The previous options
	 */
	public function update( $new_instance, $old_instance ) {
		$instance = array();
		$instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
		$instance['phone'] = ( ! empty( $new_instance['phone'] ) ) ? strip_tags( $new_instance['phone'] ) : '';
		$instance['email'] = ( ! empty( $new_instance['email'] ) ) ? strip_tags( $new_instance['email'] ) : '';
		$instance['address'] = ( ! empty( $new_instance['address'] ) ) ? strip_tags( $new_instance['address'] ) : '';
		$instance['address_url'] = ( ! empty( $new_instance['address_url'] ) ) ? strip_tags( $new_instance['address_url'] ) : '';

		return $instance;
	}
}