<?php get_header();

global $gfxbucket_options;

$layout = 0;

if( isset($gfxbucket_options['gfxbucket-post-pages-type']) ) {
	$layout = $gfxbucket_options['gfxbucket-post-pages-type'];
}

$row_class = 'row blog-wrapper';
$wrapper_class = 'col-md-8 col-md-offset-2';
$masonry_type = 'masonry-3-columns';

if( $layout != 0 ) {
	$row_class .= ' blog-masonry';
	$wrapper_class = 'col-md-12';
}

if( $layout == 2 ) {
	$masonry_type = 'masonry-4-columns';
}
?>

<div class="container">
	<main id="main" class="site-main <?php echo $wrapper_class; ?>" role="main">

		<?php putRevSlider( 'Slide Home' ); ?>

		<div class="<?php echo $row_class; ?>">
			<?php
				global $image_size;
				$image_size = 'blog';
				$ids = array();

				if ( have_posts() ) {
					while ( have_posts() ) { the_post();
						if( $layout == 0 ) {
							get_template_part( 'content', get_post_format() );
						} else {
							$ids[] = $post->ID;
						}
					}

					if( $layout != 0 ) {
						echo do_shortcode('[blog pagination="off" per_page="' . get_option('posts_per_page') . '" ids="' . implode(',', $ids) . '" wrapper="off" type="'. $masonry_type . '"]');
					}
				} else {
					get_template_part( 'content', 'none' );
				}
			?>
		</div>
		<div class="row">
			<nav class="page-nav">
				<?php 
					$args = array(
						'type'      => 'list',
						'next_text' => '<i class="fa fa-angle-right"></i>',
						'prev_text' => '<i class="fa fa-angle-left"></i>',
					);

					echo paginate_links( $args );
					wp_link_pages();
				?>
			</nav>
		</div>
	</main>
</div>

<?php get_footer(); ?>