<?php get_header();

global $gfxbucket_options;

$layout = 0;

if( isset($gfxbucket_options['gfxbucket-post-pages-type']) ) {
	$layout = $gfxbucket_options['gfxbucket-post-pages-type'];
}

$row_class = 'row blog-wrapper';
$wrapper_class = 'col-md-8 col-md-offset-2';
$masonry_type = 'masonry-3-columns';

if( $layout != 0 ) {
	$row_class .= ' blog-masonry';
	$wrapper_class = 'col-md-12';
}

if( $layout == 2 ) {
	$masonry_type = 'masonry-4-columns';
}
?>

<div class="container">
	
	<h1>Search results</h1>

	<main id="main" class="site-main <?php echo $wrapper_class; ?>" role="main">
		<?php if ( have_posts() ) : ?>
			<div class="<?php echo $row_class; ?>">
				<?php
					while ( have_posts() ) { the_post();
						if( $layout == 0 ) {
							//get_template_part( 'content', get_post_format() );
							
							echo "<h2>"; 
							the_title();
							echo "</h2>";

							$link = get_the_permalink();

							echo '<p>';
							the_excerpt();
							echo '</p>';

							echo '<a class="verLink" href="'.$link.'">View</a>';


						} else {
							$ids[] = $post->ID;
						}
					}

					if( $layout != 0 ) {
						echo do_shortcode('[blog pagination="off" per_page="' . get_option('posts_per_page') . '" ids="' . implode(',', $ids) . '" wrapper="off" type="'. $masonry_type . '"]');
					}
				?>
			</div>
			<div class="row">
			<?php
				$args = array(
					'type'      => 'list',
					'next_text' => '<i class="fa fa-angle-right"></i>',
					'prev_text' => '<i class="fa fa-angle-left"></i>',
					'current'   => (get_query_var('paged')) ? get_query_var('paged') : 1,
				);

				echo '<nav class="page-nav">' . paginate_links( $args ) . '</nav>';

				wp_reset_postdata();
			?>
			</div>
		<?php else : ?>
			<div class="search-error">
				<h2 class="search-error-title"><?php _e( 'We are sorry, there are no results for your search', 'dropout' ); ?></h2>
				<div class="widget_search" style="margin-bottom:60px;"><?php get_search_form(); ?></div>
			</div>
		<?php endif; ?>
	</main>
</div>
	
<?php get_footer(); ?>


<style>.site-footer { display: none !important;}</style>
<div class="widget-contact">
	<a href="https://contractworkplaces.com/web/contacto-contract-workplaces/#contactanos">
		<img src="https://contractworkplaces.com/web/wp-content/uploads/general/widget-contact-icon.svg" alt="Hablemos">
		<img src="https://contractworkplaces.com/web/wp-content/uploads/general/widget-contact.svg" alt="Contacto"
			 class="widget-contact__title">
	</a>
</div>
 

<div class="modal modal--newsletter">
  <div class="modal__close close--newsletter">
    <svg xmlns="http://www.w3.org/2000/svg" width="28.243" height="28.243" viewBox="0 0 28.243 28.243">
      <g id="icon_close" data-name="close" transform="translate(488.621 -23.379)">
        <line id="line_1" data-name="line 1" x2="24" y2="24" transform="translate(-486.5 25.5)" fill="none"
          stroke="#fff" stroke-linecap="round" stroke-width="2" />
        <line id="line_2" data-name="line 2" x1="24" y2="24" transform="translate(-486.5 25.5)" fill="none"
          stroke="#fff" stroke-linecap="round" stroke-width="2" />
      </g>
    </svg>
  </div>
  <div class="modal__container">
    <?php echo do_shortcode( '[contact-form-7 id="5528" title="Formulario - Newsletter"]' ); ?>
  </div>
</div>


<script>
	// Newsletter
	const triggerNewsletter = document.querySelector('.footer__newsletter_button');
	const closeNewsletter = document.querySelector('.close--newsletter');

	triggerNewsletter.addEventListener('click', function () {
		event.preventDefault();
		document.querySelector('body').classList.toggle('is--newsletter');
	});

	closeNewsletter.addEventListener('click', function () {
		document.querySelector('body').classList.toggle('is--newsletter');
	});
</script>